<?php
/*
Template Name: Contact
Description: This is a simple contact form created by c.bavota at http://bavotasan.com 
*/
?>
<?php session_start(); ?>
<?php
$directory = str_replace("contact.php","",__FILE__);

include_once $directory . '/securimage/securimage.php';

$securimage = new Securimage();

$contactpage = "contact"; // change if you do not have pretty permalinks enabled
   
if (@$_GET['first'] == "no") {
	$From = Trim(stripslashes($_POST['Name'])); 
	$EmailFrom = Trim(stripslashes($_POST['Email'])); 
	$EmailTo = 'cbavota@tinkerpriestmedia.com'; // change this to your EMAIL ADDRESS
	$Subject = 'Request from Your Website'; // change this to the name of YOUR WEBSITE
	$Name = Trim(stripslashes($_POST['Name'])); 
	$Email = Trim(stripslashes($_POST['Email'])); 
	$Message = Trim(stripslashes($_POST['Message'])); 
	
	// validation
	if ($securimage->check($_POST['captcha_code']) == false) {
		echo get_header();
		echo '<h1>Contact</h1>';
		echo '<p>There was an error with your captcha validation code. Please try again.<br /><br /><a href="'; bloginfo("url"); echo "/".$contactpage.'">Return to contact page</a>.</p>';
		echo get_footer();
		exit;
	}
	if ($Name && $Email && $Message) { 
		$validationOK=true;
		} else {
		$validationOK=false;
		}
	if (!$validationOK) {
		echo get_header();
		echo '<h1>Contact</h1>';
		echo '<p>There was an error with your message. Please try again.<br /><br /><a href="'; bloginfo("url"); echo "/".$contactpage.'">Return to contact page</a>.</p>';
		echo get_footer();
		exit;
	}
	
	// prepare email body text
	$Body = "";
	$Body .= "Name: ";
	$Body .= $Name;
	$Body .= "\n";
	$Body .= "Email: ";
	$Body .= $Email;
	$Body .= "\n";
	$Body .= "\n";
	$Body .= "Message: ";
	$Body .= "\n";
	$Body .= $Message;
	
	// send email 
	$success = mail($EmailTo, $Subject, $Body, "From: $From <$EmailFrom>");
	
	// redirect to success page 
	if ($success){
		echo get_header();
		echo '<h1>Contact</h1>';
		echo '<p>Thank you. Your message has been sent.</p>';
		echo get_footer();
	} else {
		echo get_header();
		echo '<h1>Contact</h1>';
		echo '<p>There was an error with your message. Please try again.<br /><br /><a href="'; bloginfo("url"); echo "/".$contactpage.'">Return to contact page</a>.</p>';
		echo get_footer();
	}
} else {
?>
<?php get_header(); ?>
<h1>Contact Us</h1>
    <form method="post" action="?first=no">
    <table>
    <tr>
    <td>
        <label for="Name" id="Name">Name:</label><br />
        <input type="text" name="Name" /> <small><em>(required)</em></small><br /><br />
    </td>
    </tr>
    <tr>
    <td>
        <label for="Email" id="Email">Email:</label><br />
        <input type="text" name="Email" /> <small><em>(required)</em></small><br /><br />
    </td>
    </tr>
    <tr>
    <td>	
        <label for="Message" id="Message">Message:</label> <small><em>(required)</em></small><br />
        <textarea name="Message" rows="8"></textarea><br /><br />
    </td>
    </tr>
    <tr>
    <td>	
        <label for="Code" id="Code">Type the following:</label><br />
        <img id="captcha" src="<?php bloginfo('template_url'); ?>/securimage/securimage_show.php" alt="CAPTCHA Image" style="margin: 3px;" /><br />
        <a href="#" onclick="document.getElementById('captcha').src = '<?php bloginfo('template_url'); ?>/securimage/securimage_show.php?' + Math.random(); return false">Reload Image</a><br />   <br />
     <input type="text" name="captcha_code" size="6" maxlength="4" /> <small><em>&nbsp;(required)</em></small><br />
		<br />
    </td>
    </tr>
    </table>
    <input type="submit" name="submit" value="Submit" class="submit-button" />
    </form>
<?php } ?>
<?php get_footer(); ?>